
library(dplyr)
library(stringr)
library(useful)
library(MASS)
library(reshape2)
library(epiDisplay)
library(ggplot2)


Dataf <- read.csv( "D:/Pipeline comparisons/Writing/Main/Figure 3/Data for Figure 3.csv")

Dataf95 <-Dataf[Dataf$Comparison=='pSTY95_to_pASTY',]

Dataf95 <-Dataf95[Dataf95$Category!='No Matching Sequences' & Dataf95$Category!='Matching Sequences',]

ggp95 <- ggplot(Dataf95[order(Dataf95$Category, decreasing = T),],            # Create ggplot2 plot scaled to 1.00
              aes(x = Dataset,
                  y = Matches,
                  fill=factor(Category, levels=c("NoMSeq","MSeq_NoMSite","Mseq MSite" )))) +
  geom_bar(position = "fill", stat = "identity") +
  facet_wrap(~ Pipeline, ncol= 1) 
ggp95 + scale_y_continuous(labels = scales::percent_format()) +
  theme(legend.title=element_blank(),text = element_text(size = 14))
# Draw ggplot2 plot scaled to 1.00

Dataf05 <-Dataf[Dataf$Comparison=='pASTY05_to_pSTY',]

Dataf05 <-Dataf05[Dataf05$Category!='No Matching Sequences' & Dataf05$Category!='Matching Sequences',]

ggp05 <- ggplot(Dataf05[order(Dataf05$Category, decreasing = T),],            # Create ggplot2 plot scaled to 1.00
              aes(x = Dataset,
                  y = Matches,
                  fill=factor(Category, levels=c("NoMSeq","MSeq_NoMSite","Mseq MSite" )))) +
  geom_bar(position = "fill", stat = "identity") +
  facet_wrap(~ Pipeline, ncol= 1) 
ggp05 + scale_y_continuous(labels = scales::percent_format()) +
  theme(legend.title=element_blank(),text = element_text(size = 14))